<?php

class Ultimate_AI_Elementor_Init 
{
	function __construct() {
		add_action( 'elementor/widgets/register', [ $this, 'register_elementor_elements' ] );
		add_action( 'elementor/elements/categories_registered', [ $this, 'register_elementor_category' ] );
		add_action( 'wp_enqueue_scripts', [ $this, 'register_elements_scripts' ] );
	}

	function register_elementor_elements( $widgets_manager ) {
		$this->load_widgets_files();
		$widgets_manager->register( new Element_Ultimate_AI_Login_Register_Form() );
		$widgets_manager->register( new Element_Ultimate_AI_Google_Login_Register_Button() );
	}

	function register_elementor_category( $elements_manager ) {
		$elements_manager->add_category(
			'ultimate_ai_catetory',
			[
				'title' => esc_html__( 'Ultimate AI', ULTIMATE_AI_SLUG ),
				'icon' => 'fa fa-plug',
			]
		);
	}

	function register_elements_scripts() {
		//JS
		wp_register_script( "element_ultimate_ai_login_register_form", UAI_ASSETS_URL_JS . "element_ultimate_ai_login_register_form.bundle.js", array("wp-i18n","jquery"), UAI_VERSION, true );
		wp_localize_script( "element_ultimate_ai_login_register_form", "UAI_LOCAL", Ultimate_AI_Base::ultimate_ai_get_local_variable() );

		wp_register_script( "element_ultimate_ai_google_login_register_btn", UAI_ASSETS_URL_JS . "element_ultimate_ai_google_login_register_btn.bundle.js", array("wp-i18n","jquery"), UAI_VERSION, true );
		wp_localize_script( "element_ultimate_ai_google_login_register_btn", "UAI_LOCAL", Ultimate_AI_Base::ultimate_ai_get_local_variable() );

		//CSS
	}


	function load_widgets_files() {
		include_once( __DIR__ . "/elements/login_register_form.php" );
		include_once( __DIR__ . "/elements/google_login_register_btn.php" );
	}

}

new Ultimate_AI_Elementor_Init();
